#Proyecto 5.1. Marquemos las puntas

Construí un programa que ponga 4 bolitas verdes una en cada esquina del tablero; 
es como si pusieses algo en cada rincón de una habitación. 
El desafío es construir **_un solo programa_**, pero ese programa tiene que 
funcionar **_en cualquier tablero inicial_** que se nos ocurra. 
Te mostramos algunos ejemplos de cómo deberían quedar diferentes tableros finales:
                
<center>
![Algunos tableros finales resultado del programa](data:image/png;base64,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)
</center>

Investigá el entorno para descubrir algo que te permita conseguir este objetivo. 
¡Atención! Puede ser que a veces el cabezal no empiece posicionado en una esquina...

> **Probá, probá y probá**
>
> Asegurate de ejecutar el programa varias veces. 
> Cada vez que ejecutás este proyecto, el entorno usa un tablero inicial diferente. 
> Así podés ver que **_el mismo programa_** da siempre el resultado que esperás, sin 
> importar cuál es el tablero inicial. 
> Si querés elegir el tablero inicial vos, deshabilitá la opción de tablero aleatorio 
> (las flechitas al lado del botón de ejecución), y elegí el tablero que quieras 
> (con el menú de selección de tablero inicial, arriba a la izquierda del sector del tablero).
> <center>
> ![Opción de tablero aleatorio y menú de tableros](data:image/png;base64,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)
> </center>

.

> **Recordatorio**
>
> Acordate que decimos que _“el programa pone bolitas”_, pero en realidad es la máquina que 
> lo ejecuta la que pone las bolitas. 
> De la misma forma, decimos _“el programa falló”_, cuando en realidad fue la ejecución del 
> programa lo que falló. 

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/1.Descubrir%20Gobstones/5.1.Marquemos%20las%20puntas/assets/resources/description.pdf "Enunciado de 'Marquemos las puntas' en PDF"
